/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.remres;

import com.ibm.hwmca.fw.remres.ReservationManagerEvent;
import com.ibm.hwmca.fw.remres.ReservationManagerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReservationManager {
    private static final String TRACE_MASK = "XRREECCF";
    private static ReservationManager theManager = null;
    private Map reservations = new HashMap();
    private List listeners = new ArrayList();

    public static synchronized ReservationManager getReservationManager() {
        if (theManager == null) {
            theManager = new ReservationManager();
        }
        return theManager;
    }

    private ReservationManager() {
    }

    synchronized String reserve(String reservationName, String holder) {
        if (this.reservations.containsKey(reservationName)) {
            return (String)this.reservations.get(reservationName);
        }
        this.reservations.put(reservationName, holder);
        this.fireReserved(reservationName);
        return null;
    }

    synchronized void release(String reservationName) {
        Object holder = this.reservations.remove(reservationName);
        if (holder != null) {
            this.fireReleased(reservationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReserved(String name) {
        ReservationManagerEvent event = new ReservationManagerEvent(this, name);
        Iterator iterator = null;
        ReservationManager reservationManager = this;
        synchronized (reservationManager) {
            iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
        }
        while (iterator.hasNext()) {
            ((ReservationManagerListener)iterator.next()).obtained(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReleased(String name) {
        ReservationManagerEvent event = new ReservationManagerEvent(this, name);
        Iterator iterator = null;
        ReservationManager reservationManager = this;
        synchronized (reservationManager) {
            iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
        }
        while (iterator.hasNext()) {
            ((ReservationManagerListener)iterator.next()).released(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireForced(String name) {
        ReservationManagerEvent event = new ReservationManagerEvent(this, name);
        Iterator iterator = null;
        ReservationManager reservationManager = this;
        synchronized (reservationManager) {
            iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
        }
        while (iterator.hasNext()) {
            ((ReservationManagerListener)iterator.next()).forced(event);
        }
    }

    public synchronized void addListener(ReservationManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ReservationManagerListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void force(String name) {
        Object holder = this.reservations.remove(name);
        if (holder != null) {
            this.fireForced(name);
        }
    }

    public synchronized Iterator reservationKeyIterator() {
        return new ArrayList(this.reservations.keySet()).iterator();
    }
}

